# Hotel Noesis - Quick Start Guide

## 🚀 Get Started in 3 Steps

### Step 1: Open the Website
Simply double-click `index.html` to open in your default browser.

**OR** for a better experience, run a local server:

```bash
# Using Python (pre-installed on Mac/Linux)
python -m http.server 8000

# Using Node.js
npx http-server

# Then visit: http://localhost:8000
```

### Step 2: Navigate the Site
Use the header navigation to explore all pages:
- **Home** - Landing page with overview
- **Stay** - Room categories and accommodations
- **Eats** - Three restaurant venues
- **Wellness** - Spa and fitness
- **Services** - Amenities and concierge
- **Travel Info** - Directions and local area
- **Contact** - Contact form and information

### Step 3: Customize (Optional)
To make it your own:

#### Change Colors
Edit [css/styles.css](css/styles.css) (lines 15-25):
```css
:root {
  --gold-primary: #bd9a41;  /* Your brand color */
  --charcoal: #1a1a1a;      /* Your text color */
  /* etc. */
}
```

#### Update Content
Edit any `.html` file - all content is in plain HTML.

#### Replace Images
- Update logo: Replace `images/noesis_logo.png`
- Update photos: Replace Unsplash URLs with your own images

---

## 📱 Test Responsive Design

### Desktop
Open in browser at full width - optimal experience.

### Tablet
Resize browser to ~800px width - see adjusted layout.

### Mobile
Resize to ~400px width - hamburger menu activates.

**OR** Use browser DevTools (F12) → Toggle Device Toolbar

---

## ✨ Key Features to Try

1. **Scroll Animations** - Elements fade in as you scroll down
2. **Lightbox Gallery** - Click images on Stay page to enlarge
3. **Contact Form** - Try submitting with/without required fields
4. **Mobile Menu** - Resize window to see hamburger menu
5. **Hover Effects** - Hover over cards, buttons, navigation links
6. **Parallax** - Hero background moves slower than content

---

## 🎨 Pages Overview

| Page | Purpose | Special Features |
|------|---------|------------------|
| **index.html** | Home/Landing | Hero, highlights, dining preview |
| **stay.html** | Accommodations | 4 room types, image gallery |
| **eats.html** | Dining Overview | 3 restaurants with links |
| **ntangaza.html** | Restaurant 1 | African cuisine details |
| **solari.html** | Restaurant 2 | Mediterranean cuisine |
| **grove-pit.html** | Restaurant 3 | Fire & smoke cuisine |
| **wellness.html** | Spa & Fitness | Treatments, facilities |
| **services.html** | Amenities | Concierge, business services |
| **travel-info.html** | Location | Directions, attractions |
| **contact.html** | Contact | Form with validation |
| **terms.html** | Legal | Policies, terms |

---

## 🛠️ Common Customizations

### Update Hotel Name
Find and replace "Hotel Noesis" in all HTML files.

### Change Phone/Email
Search for `+1 (555) 123-4567` and `reservations@hotelnoesis.com` in all files.

### Update Address
Search for "123 Luxury Avenue" in all files.

### Add Your Logo
Replace `images/noesis_logo.png` with your logo (recommended size: 200x100px PNG with transparency).

### Modify Navigation
Edit the `<nav>` section in each HTML file's header (around line 20-35).

---

## 📂 File Reference

```
Essential Files:
├── index.html              Start here!
├── css/styles.css          All styling
├── js/main.js              All interactions
└── images/noesis_logo.png  Your logo

Page Files (in /pages/):
├── stay.html               Rooms
├── eats.html               Dining
├── wellness.html           Spa
├── services.html           Amenities
├── contact.html            Contact form
└── ... (8 more pages)

Documentation:
├── README.md               Full documentation
├── PROJECT_SUMMARY.md      Project overview
└── QUICK_START.md          This file
```

---

## 💡 Tips

### For Viewing
- Use Chrome, Firefox, Safari, or Edge (latest versions)
- Enable JavaScript for full functionality
- Desktop browser recommended for initial viewing

### For Editing
- Use any text editor (VS Code, Sublime, Atom, etc.)
- Search for TODO comments if you added any customizations
- Test in browser after each change

### For Deployment
- Upload all files to your web host
- Keep folder structure intact
- Ensure file paths work (test all links)
- Replace demo images with real photos

---

## 🆘 Troubleshooting

### Logo not showing?
- Check that `images/noesis_logo.png` exists
- Verify file path in HTML is correct

### Styles not loading?
- Check that `css/styles.css` exists
- Open browser console (F12) for errors

### JavaScript not working?
- Check that `js/main.js` exists
- Ensure JavaScript is enabled in browser
- Check browser console for errors

### Images not loading?
- Unsplash URLs require internet connection
- Replace with local images if needed

---

## 🎯 Next Steps

1. ✅ View the complete website
2. ✅ Test all pages and features
3. ✅ Customize colors and content
4. ✅ Replace images with your own
5. ✅ Deploy to your web hosting

---

## 📞 Need Help?

- Check [README.md](README.md) for detailed documentation
- Review [PROJECT_SUMMARY.md](PROJECT_SUMMARY.md) for overview
- Inspect code comments in HTML/CSS/JS files

---

**Enjoy your luxury hotel website!** 🏨✨
